package sim.engine;

public class Signal extends Data
{
	private EnginePeer source;
	private int pin;
	private boolean toFloat;
	private double time;
	
	public Signal(boolean newValue, double newTime, boolean newUndefined, EnginePeer origin, int sPin)
	{
		super(newValue, newUndefined);
		this.time = newTime;
		this.source = origin;
		this.pin = sPin;
		this.toFloat = false;
	}
	
	public Signal(double newTime, EnginePeer origin, int sPin)
	{
		super(false, true);
		this.time = newTime;
		this.source = origin;
		this.pin = sPin;
		this.toFloat = true;
	}
	
	public boolean wantToFloat()
	{
		return this.toFloat;
	}
	
	public int getPin()
	{
		return this.pin;
	}
	
	public double getTime()
	{
		return this.time;
	}
	
	public EnginePeer getSource()
	{
		return this.source;
	}
}
